/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWSessionInfo;
import javax.swing.ImageIcon;

public class VWConfigRosterNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    private static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("roster_32.gif");
    private static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("roster_16.gif");
    private VWRosterDefinition m_rosterDefinition = null;
    private VWSystemConfiguration m_configuration = null;

    public VWConfigRosterNode(VWSessionInfo sessionInfo, VWRosterDefinition rosterDef, String service, int regionID, int serverID, VWSystemConfiguration sysConfig) {
        super(rosterDef.getName(), 3, VWConfigActionCommand.ACMD_ROSTER);
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_rosterDefinition = rosterDef;
            this.m_serviceName = service;
            this.m_regionID = regionID;
            this.m_serverID = serverID;
            this.m_configuration = sysConfig;
            this.m_description = rosterDef.getDescription();
            this.setIcon32(nodeIcon32);
            this.setIcon16(nodeIcon16);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int countWorkItemsAffected() {
        try {
            if (this.m_eventStatus != 10) {
                VWRoster vwRoster = this.m_sessionInfo.getSession().getRoster(this.m_name);
                this.m_workItemsAffected = vwRoster.fetchCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_workItemsAffected;
    }

    public Object clone() {
        VWConfigRosterNode rNode = (VWConfigRosterNode)super.clone();
        rNode.m_rosterDefinition = (VWRosterDefinition)this.m_rosterDefinition.clone();
        rNode.m_configuration = this.m_configuration;
        return rNode;
    }

    protected VWRosterDefinition getDefinition() {
        if (this.m_rosterDefinition != null) {
            return (VWRosterDefinition)this.m_rosterDefinition.clone();
        }
        return null;
    }

    protected void setDefinition(VWRosterDefinition newRosterDef) {
        try {
            if (this.m_configuration != null && newRosterDef != null) {
                this.m_configuration.updateRosterDefinition(newRosterDef);
                this.m_rosterDefinition = newRosterDef;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_rosterDefinition = null;
        this.m_configuration = null;
        super.releaseResources();
    }

    public void selectExportComponents() {
        try {
            VWClassFactory.setIsSelectedForExport(this.m_rosterDefinition, this.m_exportOpt == 2, 234L);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

